/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.render.particle;

import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityDropParticleFX
extends EntityFX {
    private int bobTimer;

    public EntityDropParticleFX(World world, double d, double d2, double d3, float f, float f2, float f3) {
        this(world, d, d2, d3, f, f2, f3, -1);
    }

    public EntityDropParticleFX(World world, double d, double d2, double d3, float f, float f2, float f3, int n) {
        super(world, d, d2, d3, 0.0, 0.0, 0.0);
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.particleRed = f;
        this.particleGreen = f2;
        this.particleBlue = f3;
        this.setParticleTextureIndex(113);
        this.setSize(0.01f, 0.01f);
        this.particleGravity = -0.06f * (float)n;
        this.bobTimer = 40;
        this.particleMaxAge = (int)(48.0 / (Math.random() * 0.8 + 0.2));
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)this.particleGravity;
        if (this.bobTimer-- > 0) {
            this.motionX *= 0.02;
            this.motionY *= 0.02;
            this.motionZ *= 0.02;
            this.setParticleTextureIndex(113);
        } else {
            this.setParticleTextureIndex(112);
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.particleMaxAge-- <= 0) {
            this.setDead();
        }
        if (this.onGround) {
            this.setParticleTextureIndex(114);
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
        if (this.particleGravity > 0.0f) {
            double d;
            Material material = this.worldObj.getBlock(MathHelper.floor(this.posX), MathHelper.floor(this.posY), MathHelper.floor(this.posZ)).getMaterial();
            if ((material.isLiquid() || material.isSolid()) && this.posY < (d = (double)((float)(MathHelper.floor(this.posY) + 1) - BlockLiquid.getLiquidHeightPercent((int)this.worldObj.getBlockMetadata(MathHelper.floor(this.posX), MathHelper.floor(this.posY), MathHelper.floor(this.posZ)))))) {
                this.setDead();
            }
        } else {
            double d;
            Material material = this.worldObj.getBlock(MathHelper.ceil(this.posX), MathHelper.ceil(this.posY), MathHelper.ceil(this.posZ)).getMaterial();
            if ((material.isLiquid() || material.isSolid()) && this.posY > (d = (double)((float)(MathHelper.ceil(this.posY) + 1) - BlockLiquid.getLiquidHeightPercent((int)this.worldObj.getBlockMetadata(MathHelper.ceil(this.posX), MathHelper.ceil(this.posY), MathHelper.ceil(this.posZ)))))) {
                this.setDead();
            }
        }
    }
}

